package ga.core.algorithm.util;

import java.util.Random;

import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomAdaptor;

/**
 * Utility class that holds a single instance of a {@link MersenneTwister}
 * random.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public final class RandomSingleton {
  private static Random rnd = new RandomAdaptor(new MersenneTwister());

  /**
   * Instantiation is not allowed.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  private RandomSingleton() {
  }

  /**
   * Getter for the single instance of the {@link MersenneTwister} random.
   * 
   * @return The random.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public static Random getRandom() {
    return rnd;
  }
}
